%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Function name: plot_corr_check
%
% Scope:    plot correlations vs instrumental parameters and R^2 values
%
% Input:    data (structure),
%           bindata (structure),
%           binref (structure),
%           list of gas names (cell),
%           list of gas type "flags" (i.e., MPV positions) (double),
%           anchor gas name (string)
%
% Output:   figure correlations vs instrumental parameters
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function plot_corr_check(bindata,binref,gasnames,par_corr_anchor)

tic;fprintf('Running function check_correlations...\n');

ind_anchor=find(ismember(gasnames,par_corr_anchor));

fitcoeff = calc_fit_coeff(bindata,gasnames,par_corr_anchor);

target_vec=[2 4 5 6];
bindata_vec=[7 8 9 10];
rsquared=NaN(width(bindata_vec),1);

    figure;
for k=1:width(target_vec)
    for i=1:width(bindata_vec)

        target_idx=target_vec(1,k);
        bindata_idx=bindata_vec(1,i);
        slope = fitcoeff.slope(target_idx,bindata_idx);
        intercept = fitcoeff.intercept(target_idx,bindata_idx);

        subplot(4,4,i+4*(k-1));
        scatter(bindata.(gasnames{1,ind_anchor})(:,bindata_idx),bindata.(gasnames{1,ind_anchor})(:,target_idx));
        hold on;
        plot([min(bindata.(gasnames{1,ind_anchor})(:,bindata_idx)) max(bindata.(gasnames{1,ind_anchor})(:,bindata_idx))],slope(1,1)*[min(bindata.(gasnames{1,ind_anchor})(:,bindata_idx)) max(bindata.(gasnames{1,ind_anchor})(:,bindata_idx))]+intercept(1,1),'-r');
        yline(binref.(gasnames{1,ind_anchor})(1,target_idx),'--k');
        xline(binref.(gasnames{1,ind_anchor})(1,bindata_idx),'--k');
        grid on;
        box on;
        xlabel({sprintf('%s',bindata.varlabels{1,bindata_idx})},'fontsize',12);
        ylabel({sprintf('%s',bindata.varlabels{1,target_idx})},'fontsize',12);
        legend(string(gasnames{1,ind_anchor}),'linear fit','fontsize',10);

        x0 = 10;
        y0 = 150;
        ww = 900;
        hh = 400;
        set(gcf,'units','points','position',[x0,y0,ww,hh]);
        set(gcf,'Units','Inches');
        pos = get(gcf,'Position');
        set(gcf,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3),pos(4)]);

        %calculate r^2
        yy = bindata.(gasnames{1,ind_anchor})(:,target_idx);
        yy_calc = slope(1,1)*bindata.(gasnames{1,ind_anchor})(:,bindata_idx)+intercept(1,1);
        rsquared(i,1) = 1 - sum((yy - yy_calc).^2)/sum((yy - mean(yy)).^2);
        XL = get(gca, 'XLim');
        YL = get(gca, 'YLim');
        text(XL(1,1)+0.02*(XL(1,2)-XL(1,1)),YL(1,1)+0.92*(YL(1,2)-YL(1,1)),['{\itR^2} = ', sprintf('%1.3f',rsquared(i,1)) ],'color','r');

    end
end

time_elapsed=toc; fprintf('check_correlations completed (execution time: %1.2f s)\n',time_elapsed);

end

